#include <Adafruit_NeoPixel.h>

// WS2812B LED Picture Frame Rainbow
// Coded By ChokunPlayZ
//
// TikTok : @chokunplayz_100k
// Instragram : @chokunplayz
// YouTube : ChokunPlayZ
// Website : https://www.chokunplayz.com/
// Github : https://github.com/ChokunPlayZ
//
// Serial Baud Rate : 9600

//แก้ใขข้อมูลหลังจากตรงนี้

#define LED_PIN    6 //Data Pin ที่ต่อไปหลอด LED

#define LED_COUNT 33 //จำนวน Pixel ของหลอด

//ห้ามแก้ใข Code หลังจากนี้

#ifdef __AVR__
 #include <avr/power.h>
#endif

Adafruit_NeoPixel strip(LED_COUNT, LED_PIN, NEO_GRB + NEO_KHZ800);

void setup() {
#if defined(__AVR_ATtiny85__) && (F_CPU == 16000000)
  clock_prescale_set(clock_div_1);
#endif
  Serial.begin(9600);
  acs77();
  delay(100);
  Serial.println("Resetting LEDs");
  strip.begin();
  strip.show();
  strip.setBrightness(50);
  Serial.println("LEDs Reset Complete");
  Serial.println("");
  delay(1000);
  
}

void loop() {
  rainbow(10);
  //colorwhite();
}

void startup() {
  colorWipe(strip.Color(255, 0, 0), 50);
  strip.show(); 
  delay(1000);
  colorWipe(strip.Color(0, 255, 0), 50);
  strip.show(); 
  delay(1000);
  colorWipe(strip.Color(0, 0, 255), 50);
  strip.show(); 
  delay(1000);
  colorWipe(strip.Color(0, 0, 0), 50);
  strip.show(); 
  delay(1000);
}

void colorwhite() {
  colorWipe(strip.Color(255, 255, 255), 50);
  strip.show(); 
}

void colorWipe(uint32_t color, int wait) {
  for(int i=0; i<strip.numPixels(); i++) {
    strip.setPixelColor(i, color);
  }
}

void rainbow(int wait) {
  for(long firstPixelHue = 0; firstPixelHue < 5*65536; firstPixelHue += 256) {
    for(int i=0; i<strip.numPixels(); i++) {
      int pixelHue = firstPixelHue + (i * 65536L / strip.numPixels());
      strip.setPixelColor(i, strip.gamma32(strip.ColorHSV(pixelHue)));
    }
    strip.show();
    delay(wait);
  }
}

void acs77() {
  Serial.println("WS2812B LED Picture Frame Rainbow");
  Serial.println("Coded By ChokunPlayZ");
  Serial.println("");
  Serial.println("TikTok : @chokunplayz_100k");
  Serial.println("Instragram : @chokunplayz");
  Serial.println("YouTube : ChokunPlayZ");
  Serial.println("Website : https://www.chokunplayz.com/");
  Serial.println("Github : https://github.com/ChokunPlayZ");
  Serial.println("");
}
